ORCA/M Asm65816 2.1.0

0001 C846                       title 'Desk Manager--CDACalls'
0002 C846              **********************************************************************
0003 C846              *
0004 C846              * Desk Manager--CDACalls  
0005 C846              * for the Apple II GS
0006 C846              *
0007 C846              * original CDA code by John Worthinton.
0008 C846              * original NDA code by Steven Glass
0009 C846              *
0010 C846              * Additions and alterations by Steven Glass and
0011 C846              * Konstantin Othmer
0012 C846              *
0013 C846              *
0014 C846              * This file contains
0015 C846              *
0016 C846              *	SaveScreen
0017 C846              *	svscreen
0018 C846              *	RestScreen
0019 C846              *	rstscreen
0020 C846              *	SaveAll
0021 C846              *	svmousstate
0022 C846              *	rstmousstate
0023 C846              *	RestAll
0024 C846              *	InstCDA
0025 C846              *	MyDeref
0026 C846              *	GrowTable
0027 C846              *	RemoveCDA
0028 C846              *	SetDAStrPtr
0029 C846              *	GetDAStrPtr
0030 C846              *
0031 C846              **********************************************************************
0032 C846
0033 C846              **********************************************************************
0034 C846              *                                                                    *
0035 C846              *                   Copyright (C) 1985-1988                          *
0036 C846              *                   All Rights Reserved                              *
0037 C846              *                   Apple Computer, Inc.                             *
0038 C846              *                                                                    *
0039 C846              **********************************************************************
0040 C846
0041 C846
0042 C846
0043 C846
0044 C846              **********************************************************************
0045 C846              *
0046 C846              * Change History
0047 C846              *
0048 C846              *
0049 C846              * 11 February 87      Steven Glass
0050 C846              *
0051 C846              *    Both SaveScreen and RestoreScreen went to EndCall0
0052 C846              *    when complete but had not pushed D on the stack.
0053 C846              *    They now use oEndCall0.
0054 C846              *
0055 C846              * 26-Sep-90         Dave Lyons
0056 C846              *
0057 C846              * Changed setmode8 to shortmx, setmode16 to longmx.
0058 C846              *
0059 C846              **********************************************************************
0060 C846
0061 C846
0062 C846                       include 'all.macros' 
0063 C846                       include '::sys.equs.asm' 
0064 C846                       include 'e16.memory' 
0065 C846
0066 C846
0067 C846              DAVersionNumber equ   $8300             ;8300
0068 C846
0069 C846
0070 C846                       include 'Desk.Equates.asm' 
0071 C846
0072 C846
0073 C846              ; Desk Manager memory usage
0074 C846
0075 C846              ; The desk manager has 4.5k of dedicated ram in bank E0.
0076 C846              ; The memory (from $E0/0C00 to $E0/DFFF) is used as follows:
0077 C846
0078 C846              ; bank 00 text screen saved at $E0/0C00
0079 C846              ; bank 01 text screen saved at $E0/1000
0080 C846              ; bank E0 text screen saved at $E0/1400
0081 C846              ; bank E1 text screen saved at $E0/1800
0082 C846              ; zero page (bank 00 page 00) saved at $E0/1C00
0083 C846              ; desk manager data space is 1 page starting at $E0/1D00
0084 C846
0085 C846              ****************************************************************
0086 C846
0087 C846                       longa on
0088 C846                       longi on
0089 C846
0090 C846
0091 C846              ****************************************************************
0092 C846              ;
0093 C846              ;    svscreen -- save the 80-col text screen
0094 C846              ;
0095 C846              ;    Note that the quick entry points don't save the bank.
0096 C846              ;    When the routine returns the data bank is set to E0.
0097 C846              ;    If you really want the data bank preserved, use the tool
0098 C846              ;    entries.
0099 C846
0100 C846
0101 C846
0102 C846              ; This is the tool call for saving the screen. The desk manager
0103 C846              ; currently calls the svscreen directly. Is this wrong?!?
0104 C846
0105 C846
0106 C846              savescreen PROC EXPORT
0107 C846 8B                    phb   
0108 C847 20 4F C8              jsr   svscreen
0109 C84A AB                    plb   
0110 C84B 5C DF FB FE           jml   oEndCall0                ; right end call 11 Feb 87 SEG
0111 C84F
0112 C84F                       ENDP 
0113 C84F
0114 C84F
0115 C84F
0116 C84F
0117 C84F              svscreen PROC EXPORT
0118 C84F
0119 C84F C2 30                 longmx 
0120 C851 A2 00 04              ldx   #$400                    ;save bank 00 main
0121 C854 A0 00 0C              ldy   #$0C00
0122 C857 A9 FF 03              lda   #$3FF
0123 C85A 54 E0 00              mvn   $000000,$E00000
0124 C85D
0125 C85D A2 00 04              ldx   #$400                    ;save bank 00 aux
0126 C860 A0 00 10              ldy   #$1000
0127 C863 A9 FF 03              lda   #$3FF
0128 C866 54 E0 01              mvn   $010000,$E00000
0129 C869
0130 C869 A2 00 04              ldx   #$400                    ;save bank E0 main
0131 C86C A0 00 14              ldy   #$1400
0132 C86F A9 FF 03              lda   #$3FF
0133 C872 54 E0 E0              mvn   $E00000,$E00000
0134 C875
0135 C875 A2 00 04              ldx   #$400                    ;save bank E0 aux
0136 C878 A0 00 18              ldy   #$1800
0137 C87B A9 FF 03              lda   #$3FF
0138 C87E 54 E0 E1              mvn   $E10000,$E00000
0139 C881
0140 C881 60                    rts   
0141 C882
0142 C882                       ENDP 
0143 C882
0144 C882
0145 C882              ****************************************************************
0146 C882              ;
0147 C882              ;    RestoreScreen -- restore the 80-col text screen in
0148 C882              ;                     bank 00 and bank E0
0149 C882              ;
0150 C882              ;    Same note as above. If you wnat the data bank preserved, call
0151 C882              ;    restorescreen, instead of rstscreen.
0152 C882
0153 C882              ; This is the tool entry to rstscreen. Should the manager use this too?
0154 C882
0155 C882
0156 C882              restScreen PROC EXPORT
0157 C882
0158 C882 8B                    phb   
0159 C883 20 8B C8              jsr   rstscreen
0160 C886 AB                    plb   
0161 C887 5C DF FB FE           jml   oEndCall0                ; right end call 11 Feb 87
0162 C88B
0163 C88B                       ENDP 
0164 C88B
0165 C88B
0166 C88B              rstscreen PROC EXPORT
0167 C88B
0168 C88B
0169 C88B C2 30                 longmx 
0170 C88D
0171 C88D A2 07 00              ldx   #$07
0172 C890 EC 6A 1D     loop     cpx   |mymslot
0173 C893 F0 08                 beq   @1
0174 C895 E0 03 00              cpx   #$03
0175 C898 F0 03                 beq   @1
0176 C89A 20 D1 C8              jsr   copysholes
0177 C89D CA           @1       dex   
0178 C89E D0 F0                 bne   loop
0179 C8A0
0180 C8A0 A2 00 0C              ldx   #$C00                    ;restore bank 0 main
0181 C8A3 A0 00 04              ldy   #$400
0182 C8A6 A9 FF 03              lda   #$3FF
0183 C8A9 54 00 E0              mvn   $E00000,$000000
0184 C8AC
0185 C8AC A2 00 10              ldx   #$1000                   ;restore bank 0 aux
0186 C8AF A0 00 04              ldy   #$400
0187 C8B2 A9 FF 03              lda   #$3FF
0188 C8B5 54 01 E0              mvn   $E00000,$010000
0189 C8B8
0190 C8B8 A2 00 14              ldx   #$1400                   ;restore bank E0 main
0191 C8BB A0 00 04              ldy   #$400
0192 C8BE A9 FF 03              lda   #$3FF
0193 C8C1 54 E0 E0              mvn   $E00000,$E00000
0194 C8C4
0195 C8C4 A2 00 18              ldx   #$1800                   ;restore bank E0 aux
0196 C8C7 A0 00 04              ldy   #$400
0197 C8CA A9 FF 03              lda   #$3FF
0198 C8CD 54 E1 E0              mvn   $E00000,$E10000
0199 C8D0
0200 C8D0 60                    rts   
0201 C8D1
0202 C8D1
0203 C8D1 E2 30        copysholes shortmx 
0204 C8D3 BF 78 04 00           lda   >$000478,x
0205 C8D7 9F 78 14 E0           sta   >$E01478,x
0206 C8DB 9F 78 0C E0           sta   >$E00C78,x
0207 C8DF
0208 C8DF BF F8 04 00           lda   >$0004F8,x
0209 C8E3 9F F8 14 E0           sta   >$E014F8,x
0210 C8E7 9F F8 0C E0           sta   >$E00CF8,x
0211 C8EB
0212 C8EB BF 78 05 00           lda   >$000578,x
0213 C8EF 9F 78 15 E0           sta   >$E01578,x
0214 C8F3 9F 78 0D E0           sta   >$E00D78,x
0215 C8F7
0216 C8F7 BF F8 05 00           lda   >$0005F8,x
0217 C8FB 9F F8 15 E0           sta   >$E015F8,x
0218 C8FF 9F F8 0D E0           sta   >$E00DF8,x
0219 C903
0220 C903 BF 78 06 00           lda   >$000678,x
0221 C907 9F 78 16 E0           sta   >$E01678,x
0222 C90B 9F 78 0E E0           sta   >$E00E78,x
0223 C90F
0224 C90F BF F8 06 00           lda   >$0006F8,x
0225 C913 9F F8 16 E0           sta   >$E016F8,x
0226 C917 9F F8 0E E0           sta   >$E00EF8,x
0227 C91B
0228 C91B BF 78 07 00           lda   >$000778,x
0229 C91F 9F 78 17 E0           sta   >$E01778,x
0230 C923 9F 78 0F E0           sta   >$E00F78,x
0231 C927
0232 C927 BF F8 07 00           lda   >$0007F8,x
0233 C92B 9F F8 17 E0           sta   >$E017F8,x
0234 C92F 9F F8 0F E0           sta   >$E00FF8,x
0235 C933
0236 C933 C2 30                 longmx 
0237 C935 60                    rts   
0238 C936
0239 C936
0240 C936                       ENDP 
0241 C936
0242 C936              **********************************************************************
0243 C936              *
0244 C936              *     saveall  -- save the state information prior to
0245 C936              *                 activating the desk accessory.
0246 C936              *
0247 C936              * Change History
0248 C936              *
0249 C936              * 3 Jun 87     JW and SEG
0250 C936              *
0251 C936              * When SaveAll and RestoreAll deal with mmode, it is possible
0252 C936              * for the code to become confused.  The code that looks for
0253 C936              * the mouse card initializes the mmode word in 8 bit mode.
0254 C936              * It later reads the word in 16 bit mode and if the
0255 C936              * uninitialized byte powered up with the high bit set,
0256 C936              * then the code thinks the mouse is off even when it is on.
0257 C936              *
0258 C936              * The fix here is to always zero the mmode before calling
0259 C936              * the old code.
0260 C936              *
0261 C936
0262 C936              **********************************************************************
0263 C936              saveall  PROC EXPORT
0264 C936
0265 C936
0266 C936 A9 00 00              lda   #0
0267 C939 8F 68 1D E0           sta   >mmode
0268 C93D
0269 C93D
0270 C93D E2 30                 shortmx 
0271 C93F 8B                    phb   
0272 C940
0273 C940 68                    pla   
0274 C941 8F 00 1D E0           sta   >bregsave
0275 C945
0276 C945 A9 E0                 lda   #$E0                     ; set data bank reg to $E0
0277 C947 48                    pha   
0278 C948 AB                    plb   
0279 C949
0280 C949
0281 C949 A9 00                 lda   #$00
0282 C94B 8D 02 1D              sta   |intstatus
0283 C94E              ; Make sure that main memory, etc is set correctly.
0284 C94E
0285 C94E AD 68 C0              lda   |statereg                ; set memory state
0286 C951 8D 03 1D              sta   |svstatereg
0287 C954 A9 0C                 lda   #$0C
0288 C956 8D 68 C0              sta   |statereg                ; mega // kludge
0289 C959
0290 C959              ; The code here should save the interrupt info, so we can handle
0291 C959              ; multiple desk accessories.
0292 C959
0293 C959
0294 C959 8B                    phb   
0295 C95A AD 02 1D              lda   |intstatus
0296 C95D C2 30                 longmx 
0297 C95F 10 03                 bpl   czz
0298 C961 4C D2 CA              jmp   cantopen
0299 C964 F0 08        czz      beq   int2a
0300 C966 A2 C3 00              ldx   #irq_intflag**$FFFF
0301 C969 A0 20 1D              ldy   #int1ay**$FFFF
0302 C96C 80 06                 bra   czz1
0303 C96E
0304 C96E A2 C3 00     int2a    ldx   #irq_intflag**$FFFF
0305 C971 A0 39 1D              ldy   #int2ay**$FFFF
0306 C974
0307 C974 A9 0C 00     czz1     lda   #$0C
0308 C977 54 E0 E1              mvn   $E10000,$E00000
0309 C97A
0310 C97A E2 30                 shortmx 
0311 C97C AC 02 1D              ldy   |intstatus
0312 C97F AF D7 00 E1           lda   >irq_mousvbl
0313 C983 99 61 1D              sta   |mousvblsv,y
0314 C986 C2 30                 longmx 
0315 C988
0316 C988 98                    tya   
0317 C989 F0 08                 beq   int2b
0318 C98B A2 08 01              ldx   #irq_a**$FFFF
0319 C98E A0 2D 1D              ldy   #int1by**$FFFF
0320 C991 80 06                 bra   czz2
0321 C993
0322 C993 A2 08 01     int2b    ldx   #irq_a**$FFFF
0323 C996 A0 4C 1D              ldy   #int2by**$FFFF
0324 C999 A9 13 00     czz2     lda   #$13
0325 C99C 54 E0 E1              mvn   $E10000,$E00000
0326 C99F AB                    plb   
0327 C9A0
0328 C9A0 0B                    phd                            ;save the direct page and set
0329 C9A1 68                    pla                            ; it to page 00 bank 00.
0330 C9A2 8D 63 1D              sta   |dirpgsv
0331 C9A5
0332 C9A5 A9 00 00              lda   #$00
0333 C9A8 48                    pha   
0334 C9A9 2B                    pld   
0335 C9AA
0336 C9AA E2 30                 shortmx 
0337 C9AC
0338 C9AC              ; Save the video mode softswitches.
0339 C9AC
0340 C9AC AD 18 C0              lda   |rd80col
0341 C9AF 8D 04 1D              sta   |col80sv
0342 C9B2 AD 29 C0              lda   |newvideo
0343 C9B5 8D 18 1D              sta   |newvidsv
0344 C9B8
0345 C9B8 C2 30                 longmx 
0346 C9BA AD 1A C0              lda   |rdtext                  ;save rdtext and rdmix
0347 C9BD 8D 1A 1D              sta   |txtsv
0348 C9C0 AD 1C C0              lda   |rdpage2                 ;save rdpage2 and rdhires
0349 C9C3 8D 1C 1D              sta   |page2sv
0350 C9C6 AD 1E C0              lda   |altcharset              ;save altcharset and rd80vid
0351 C9C9 8D 1E 1D              sta   |altcharsv
0352 C9CC
0353 C9CC
0354 C9CC              ; Save the 80-col text screens. Note that the mvn instruction
0355 C9CC              ; will leave the data bank register set to $E0
0356 C9CC
0357 C9CC                       longa on
0358 C9CC                       longi on
0359 C9CC
0360 C9CC 20 4F C8              jsr   svscreen
0361 C9CF
0362 C9CF              ; Save zero page (bank 00 page 00) and the 80-col video
0363 C9CF              ; screens.
0364 C9CF
0365 C9CF A2 00 00              ldx   #$0000                   ; save zp and stack
0366 C9D2 A0 00 1C              ldy   #$1C00
0367 C9D5 A9 FF 00              lda   #$FF
0368 C9D8 54 E0 00              mvn   $000000,$E00000
0369 C9DB
0370 C9DB
0371 C9DB              ; Save the mouse info. Note that the //e mouse card has to
0372 C9DB              ; be special cased. ** need to add code for that **
0373 C9DB
0374 C9DB              ; note that svmousstate must be called with 16-bit m and x.
0375 C9DB
0376 C9DB
0377 C9DB 20 D4 CA              jsr   svmousstate
0378 C9DE
0379 C9DE
0380 C9DE AF 35 01 E1           lda   >cursor
0381 C9E2 8D 16 1D              sta   |cursorsave
0382 C9E5
0383 C9E5
0384 C9E5              ; Initialize the 80-col firmware. Note that the desk manager
0385 C9E5              ; uses the basic entry points, as does the control panel.
0386 C9E5              ; Uses the fake 40-col stuff if the user has that set as a
0387 C9E5              ; preference.
0388 C9E5
0389 C9E5
0390 C9E5 E2 30                 shortmx 
0391 C9E7
0392 C9E7 38                    sec   
0393 C9E8 22 94 00 E1           jsl   tobramsetup
0394 C9EC
0395 C9EC AD 17 C0              lda   |rdc3rom
0396 C9EF 8D 65 1D              sta   |c3romsv
0397 C9F2 AD 29 C0              lda   |newvideo
0398 C9F5 29 7F                 and   #%01111111
0399 C9F7 8D 29 C0              sta   |newvideo
0400 C9FA 8D 51 C0              sta   |txtset
0401 C9FD 8D 52 C0              sta   |mixclr
0402 CA00 8D 54 C0              sta   |txtpage1
0403 CA03
0404 CA03 A9 FF                 lda   #$FF
0405 CA05 8F 32 00 00           sta   >$000032                 ; inverse switch
0406 CA09 C2 30                 longmx 
0407 CA0B
0408 CA0B 48                    pha                            ; space for result
0409 CA0C 48                    pha   
0410 CA0D 48                    pha   
0411 CA0E A2 0C 13 22           _GetOutputDevice 
0412 CA15
0413 CA15 68                    pla   
0414 CA16 8D A2 1D              sta   |oldoutdev               ; save old output globals
0415 CA19 68                    pla   
0416 CA1A 8D A4 1D              sta   |oldoutdev+2
0417 CA1D 68                    pla   
0418 CA1E 8D A6 1D              sta   |oldoutdev+4
0419 CA21
0420 CA21 48                    pha                            ; save the old output device
0421 CA22 48                    pha                            ; so we don't have any problems
0422 CA23 A2 0C 0D 22           _GetOutGlobals 
0423 CA2A
0424 CA2A 68                    pla   
0425 CA2B 8D 9E 1D              sta   |oldoutglob
0426 CA2E 68                    pla   
0427 CA2F 8D A0 1D              sta   |oldoutglob+2
0428 CA32
0429 CA32 48                    pha                            ; save the old input device
0430 CA33 48                    pha   
0431 CA34 48                    pha   
0432 CA35 A2 0C 12 22           _GetInputDevice 
0433 CA3C 68                    pla   
0434 CA3D 8D B4 1D              sta   |oldindev
0435 CA40 68                    pla   
0436 CA41 8D B6 1D              sta   |oldindev+2
0437 CA44 68                    pla   
0438 CA45 8D B8 1D              sta   |oldindev+4
0439 CA48
0440 CA48 48                    pha                            ; save the oldinput globals too
0441 CA49 48                    pha   
0442 CA4A A2 0C 0C 22           _GetInGlobals 
0443 CA51 68                    pla   
0444 CA52 8D BA 1D              sta   |oldinglob
0445 CA55 68                    pla   
0446 CA56 8D BC 1D              sta   |oldinglob+2
0447 CA59
0448 CA59 F4 FF 00              pea   $FF                      ; and mask
0449 CA5C F4 00 00              pea   $00                      ; or mask
0450 CA5F A2 0C 0A 22           _SetOutGlobals 
0451 CA66 90 02                 bcc   cz1
0452 CA68              ;	brk	01
0453 CA68 00 01                 DC B:0,1
0454 CA6A
0455 CA6A F4 00 00     cz1      pea   00                       ; device type
0456 CA6D F4 00 00 F4           pushlong #$03                  ; pointer to driver
0457 CA73 A2 0C 10 22           _SetOutputDevice 
0458 CA7A 90 02                 bcc   loop1
0459 CA7C              ;	brk	02
0460 CA7C 00 02                 DC B:0,2
0461 CA7E
0462 CA7E
0463 CA7E E2 30        loop1    shortmx 
0464 CA80 A2 00                 ldx   #$00                     ; check for 80-col card in place
0465 CA82 AD 05 C3     loop4card lda   $C305
0466 CA85 C9 38                 cmp   #$38
0467 CA87 D0 0C                 bne   nocard
0468 CA89 AD 07 C3              lda   $C307
0469 CA8C C9 18                 cmp   #$18
0470 CA8E D0 05                 bne   nocard
0471 CA90 E8                    inx   
0472 CA91 D0 EF                 bne   loop4card
0473 CA93 80 05                 bra   cz2
0474 CA95
0475 CA95 8D 0A C0     nocard   sta   |setintc3rom             ; just to make sure its really in
0476 CA98 80 E8                 bra   loop4card
0477 CA9A
0478 CA9A C2 30        cz2      longmx 
0479 CA9C F4 01 00              pea   01                       ; init device to output
0480 CA9F A2 0C 15 22           _inittextdev 
0481 CAA6 90 02                 bcc   cz3
0482 CAA8              ;	brk	03
0483 CAA8 00 03                 DC B:0,3
0484 CAAA
0485 CAAA F4 00 00     cz3      PushWord #00 
0486 CAAD F4 19 00              PushWord #$19                  ; want 40 cols
0487 CAB0 A2 03 0C 22           _ReadBParam 
0488 CAB7 68                    pla   
0489 CAB8 8D 66 1D              sta   |sv4080
0490 CABB D0 0A                 bne   cont1
0491 CABD
0492 CABD F4 11 00              pea   $11
0493 CAC0 A2 0C 18 22           _writechar 
0494 CAC7
0495 CAC7
0496 CAC7 A9 00 00     cont1    lda   #$00
0497 CACA 48                    pha   
0498 CACB AB                    plb   
0499 CACC AB                    plb   
0500 CACD
0501 CACD 58                    cli   
0502 CACE 5C DF FB FE           jml   oEndCall0
0503 CAD2
0504 CAD2
0505 CAD2
0506 CAD2              cantopen  
0507 CAD2 00 FF                 brk   $FF
0508 CAD4
0509 CAD4
0510 CAD4                       ENDP 
0511 CAD4
0512 CAD4              ****************************************************************
0513 CAD4              ;
0514 CAD4              ;    svmousstate -- save the clamp values of the mouse.
0515 CAD4              ;
0516 CAD4
0517 CAD4
0518 CAD4              ; This routine should save the clamp values for the mouse.
0519 CAD4              ; The intent is to make this routine function for both the
0520 CAD4              ; FDB mouse and the //e mouse card. The diagnostic calls for the
0521 CAD4              ; mouse card need to be added.
0522 CAD4
0523 CAD4              svmousstate PROC EXPORT
0524 CAD4
0525 CAD4              ; Cn0C : 20
0526 CAD4              ; CnFB : D6
0527 CAD4
0528 CAD4 A9 00 C7              lda   #$C700
0529 CAD7 8D 6C 1D              sta   |slot
0530 CADA              loop                                    ; 
0531 CADA AD 6C 1D              lda   |slot
0532 CADD 48                    pha   
0533 CADE E2 30                 shortmx 
0534 CAE0 A0 0C                 ldy   #$0C
0535 CAE2 B3 01                 lda   (1,s),y
0536 CAE4 C9 20                 cmp   #$20
0537 CAE6 D0 08                 bne   miss
0538 CAE8 A0 FB                 ldy   #$FB
0539 CAEA B3 01                 lda   (1,s),y
0540 CAEC C9 D6                 cmp   #$D6
0541 CAEE F0 1B                 beq   gotit
0542 CAF0
0543 CAF0 C2 30        miss     longmx 
0544 CAF2 68                    pla   
0545 CAF3 AD 6C 1D              lda   |slot
0546 CAF6 EB                    xba   
0547 CAF7 3A                    dec   a
0548 CAF8 C9 C0 00              cmp   #$C0
0549 CAFB F0 06                 beq   fail
0550 CAFD EB                    xba   
0551 CAFE 8D 6C 1D              sta   |slot
0552 CB01 80 D7                 bra   loop
0553 CB03
0554 CB03              fail                                    ; 
0555 CB03 A9 FF FF              lda   #$FFFF
0556 CB06 8D 68 1D              sta   |mmode
0557 CB09 80 6B                 bra   exit
0558 CB0B
0559 CB0B C2 30        gotit    longmx 
0560 CB0D 68                    pla   
0561 CB0E EB                    xba   
0562 CB0F 29 0F 00              and   #$0F
0563 CB12 8D 6A 1D              sta   |mymslot                 ; push mouse slot for init call
0564 CB15 18                    clc   
0565 CB16 69 F8 07              adc   #$7F8
0566 CB19 AA                    tax   
0567 CB1A                       longa off
0568 CB1A                       longi on
0569 CB1A E2 20                 sep   #$20
0570 CB1C B5 00                 lda   0,x
0571 CB1E F0 20                 beq   noton
0572 CB20
0573 CB20 8D 68 1D              sta   |mmode
0574 CB23 E2 30                 shortmx 
0575 CB25 AF E0 00 E1           lda   >mouseslot
0576 CB29 48                    pha   
0577 CB2A AD 6A 1D              lda   |mymslot
0578 CB2D 8F E0 00 E1           sta   >mouseslot
0579 CB31 C2 30                 longmx 
0580 CB33 A9 00 00              lda   #$00
0581 CB36 48                    pha   
0582 CB37 A2 03 19 22           _setmouse 
0583 CB3E
0584 CB3E 80 0A                 bra   saveclamps
0585 CB40
0586 CB40 C2 30        noton    longmx 
0587 CB42 A9 00 00              lda   #$00
0588 CB45 8D 68 1D              sta   |mmode
0589 CB48 80 2C                 bra   exit
0590 CB4A
0591 CB4A
0592 CB4A F4 00 00     saveclamps PushWord #00 
0593 CB4D F4 00 00              PushWord #00 
0594 CB50 F4 00 00              PushWord #00 
0595 CB53 F4 00 00              PushWord #00 
0596 CB56 A2 03 1D 22           _getmouseclamp 
0597 CB5D
0598 CB5D 68                    pla   
0599 CB5E 8D 0B 1D              sta   |hiyclampsv
0600 CB61 68                    pla   
0601 CB62 8D 07 1D              sta   |loyclampsv
0602 CB65 68                    pla   
0603 CB66 8D 09 1D              sta   |hixclampsv
0604 CB69 68                    pla   
0605 CB6A 8D 05 1D              sta   |loxclampsv
0606 CB6D
0607 CB6D E2 30                 shortmx 
0608 CB6F 68                    pla   
0609 CB70 8F E0 00 E1           sta   >mouseslot
0610 CB74 C2 30                 longmx 
0611 CB76
0612 CB76 60           exit     rts   
0613 CB77
0614 CB77                       ENDP 
0615 CB77
0616 CB77
0617 CB77              ****************************************************************
0618 CB77              ;
0619 CB77              ;    rstmousstate -- save the clamp values of the mouse.
0620 CB77              ;
0621 CB77
0622 CB77              ; Note that the diagnostic calls for the //e mouse card need to
0623 CB77              ; be added.
0624 CB77
0625 CB77              rstmousstate PROC EXPORT
0626 CB77
0627 CB77 AD 68 1D              lda   |mmode
0628 CB7A 30 3D                 bmi   noton
0629 CB7C F0 3B                 beq   noton
0630 CB7E E2 30                 shortmx 
0631 CB80 AF E0 00 E1           lda   >mouseslot
0632 CB84 48                    pha   
0633 CB85 AD 6A 1D              lda   |mymslot
0634 CB88 8F E0 00 E1           sta   >mouseslot
0635 CB8C C2 30                 longmx 
0636 CB8E AD 68 1D              lda   |mmode
0637 CB91 48                    pha   
0638 CB92 A2 03 19 22           _setmouse 
0639 CB99
0640 CB99 AD 05 1D              lda   |loxclampsv
0641 CB9C 48                    pha   
0642 CB9D AD 09 1D              lda   |hixclampsv
0643 CBA0 48                    pha   
0644 CBA1 AD 07 1D              lda   |loyclampsv
0645 CBA4 48                    pha   
0646 CBA5 AD 0B 1D              lda   |hiyclampsv
0647 CBA8 48                    pha   
0648 CBA9
0649 CBA9 A2 03 1C 22           _clampmouse 
0650 CBB0
0651 CBB0 E2 30                 shortmx 
0652 CBB2 68                    pla   
0653 CBB3 8F E0 00 E1           sta   >mouseslot
0654 CBB7 C2 30                 longmx 
0655 CBB9
0656 CBB9 60           noton    rts   
0657 CBBA
0658 CBBA                       ENDP 
0659 CBBA
0660 CBBA
0661 CBBA              ****************************************************************
0662 CBBA              ;
0663 CBBA              ;   restall -- put everything back the way it was.
0664 CBBA              ;
0665 CBBA              ;   called on exit from the desk manager
0666 CBBA
0667 CBBA
0668 CBBA              restall  PROC EXPORT
0669 CBBA
0670 CBBA 78                    sei                            ;turn off interrupts
0671 CBBB
0672 CBBB
0673 CBBB              ; set data bank reg to $E0
0674 CBBB
0675 CBBB E2 30                 shortmx 
0676 CBBD A9 E0                 lda   #$E0
0677 CBBF 48                    pha   
0678 CBC0 AB                    plb   
0679 CBC1
0680 CBC1
0681 CBC1              ; Restore the 80 col video switches. There might be more to be added
0682 CBC1              ; here.
0683 CBC1
0684 CBC1
0685 CBC1 AD 04 1D              lda   |col80sv
0686 CBC4 30 05                 bmi   a1
0687 CBC6 8D 00 C0              sta   |clr80col
0688 CBC9 80 03                 bra   cont
0689 CBCB 8D 01 C0     a1       sta   |set80col
0690 CBCE AD 1F 1D     cont     lda   |vid80sv
0691 CBD1 30 05                 bmi   a2
0692 CBD3 8D 0C C0              sta   |clr80vid
0693 CBD6 80 03                 bra   cont2
0694 CBD8 8D 0D C0     a2       sta   |set80vid
0695 CBDB
0696 CBDB              ; This code will restore the old interrupt info. Currently, it is
0697 CBDB              ; saved so that the desk accessory interrupt is semi-reentrant.
0698 CBDB              ; Not currently supported.
0699 CBDB
0700 CBDB
0701 CBDB 8B           cont2    phb   
0702 CBDC AD 02 1D              lda   |intstatus
0703 CBDF C2 30                 longmx 
0704 CBE1 F0 08                 beq   int2a
0705 CBE3 A2 20 1D              ldx   #int1ay**$FFFF
0706 CBE6 A0 C3 00              ldy   #irq_intflag**$FFFF
0707 CBE9 80 06                 bra   cz1
0708 CBEB
0709 CBEB A2 39 1D     int2a    ldx   #int2ay**$FFFF
0710 CBEE A0 C3 00              ldy   #irq_intflag**$FFFF
0711 CBF1
0712 CBF1 A9 0C 00     cz1      lda   #$0C
0713 CBF4 54 E1 E0              mvn   $E00000,$E10000
0714 CBF7
0715 CBF7 E2 30                 shortmx 
0716 CBF9 AB                    plb   
0717 CBFA AC 02 1D              ldy   |intstatus
0718 CBFD B9 61 1D              lda   |mousvblsv,y
0719 CC00 8F D7 00 E1           sta   >irq_mousvbl
0720 CC04 8B                    phb   
0721 CC05 C2 30                 longmx 
0722 CC07
0723 CC07 98                    tya   
0724 CC08 F0 08                 beq   int2b
0725 CC0A A2 2D 1D              ldx   #int1by**$FFFF
0726 CC0D A0 08 01              ldy   #irq_a**$FFFF
0727 CC10 80 06                 bra   cz2
0728 CC12
0729 CC12 A2 4C 1D     int2b    ldx   #int2by**$FFFF
0730 CC15 A0 08 01              ldy   #irq_a**$FFFF
0731 CC18 A9 13 00     cz2      lda   #$13
0732 CC1B 54 E1 E0              mvn   $E00000,$E10000
0733 CC1E
0734 CC1E
0735 CC1E              ; Restore the 80-col text screens
0736 CC1E
0737 CC1E
0738 CC1E
0739 CC1E 20 8B C8              jsr   rstscreen
0740 CC21
0741 CC21              ; Bank 00 page 00 restored.
0742 CC21
0743 CC21 A2 00 1C              ldx   #$1C00                   ;restore the zero page
0744 CC24 A0 00 00              ldy   #$0000
0745 CC27 A9 FF 00              lda   #$FF
0746 CC2A 54 00 E0              mvn   $E00000,$000000
0747 CC2D
0748 CC2D AB                    plb   
0749 CC2E
0750 CC2E              ; restore the mouse clamps etc. Currently, I'm only supporting
0751 CC2E              ; the FDB mouse. Will fix ...
0752 CC2E
0753 CC2E 20 77 CB              jsr   rstmousstate             ;restore mouse clamps
0754 CC31
0755 CC31              ; restore the cursor
0756 CC31
0757 CC31 AD 16 1D              lda   |cursorsave
0758 CC34 8F 35 01 E1           sta   >cursor
0759 CC38
0760 CC38              ; restore the direct page
0761 CC38
0762 CC38 AD 63 1D              lda   |dirpgsv                 ;restore the direct page
0763 CC3B 48                    pha   
0764 CC3C 2B                    pld   
0765 CC3D
0766 CC3D              ; Restore the data bank to what it was before the desk accessory
0767 CC3D
0768 CC3D E2 30                 shortmx 
0769 CC3F
0770 CC3F AD 18 1D              lda   |newvidsv
0771 CC42 29 C0                 and   #$C0
0772 CC44 0D 29 C0              ora   |newvideo
0773 CC47 8D 29 C0              sta   |newvideo
0774 CC4A AD 1E 1D              lda   |altcharsv
0775 CC4D 10 05                 bpl   aa1
0776 CC4F 8D 0F C0              sta   |setaltchar
0777 CC52 80 03                 bra   aa2
0778 CC54 8D 0E C0     aa1      sta   |clraltchar
0779 CC57 AD 1A 1D     aa2      lda   |txtsv
0780 CC5A 10 05                 bpl   aa3
0781 CC5C 8D 51 C0              sta   |txtset
0782 CC5F 80 03                 bra   aa4
0783 CC61 8D 50 C0     aa3      sta   |txtclr
0784 CC64 AD 1B 1D     aa4      lda   |mixsv
0785 CC67 10 05                 bpl   aa5
0786 CC69 8D 53 C0              sta   |mixset
0787 CC6C 80 03                 bra   aa6
0788 CC6E 8D 52 C0     aa5      sta   |mixclr
0789 CC71 AD 1C 1D     aa6      lda   |page2sv
0790 CC74 10 05                 bpl   aa7
0791 CC76 8D 55 C0              sta   |txtpage2
0792 CC79 80 03                 bra   aa8
0793 CC7B 8D 54 C0     aa7      sta   |txtpage1
0794 CC7E AD 1D 1D     aa8      lda   |hiressv
0795 CC81 10 05                 bpl   aa9
0796 CC83 8D 57 C0              sta   |hires
0797 CC86 80 03                 bra   aa10
0798 CC88 8D 56 C0     aa9      sta   |lores
0799 CC8B AD 65 1D     aa10     lda   |c3romsv
0800 CC8E 10 05                 bpl   aa11
0801 CC90 8D 0B C0              sta   |setslotc3rom
0802 CC93 80 4B                 bra   rstmem
0803 CC95 8D 0A C0     aa11     sta   |setintc3rom
0804 CC98
0805 CC98 C2 30                 longmx 
0806 CC9A AD A6 1D              lda   |oldoutdev+4
0807 CC9D 48                    pha   
0808 CC9E AD A4 1D              lda   |oldoutdev+2
0809 CCA1 48                    pha   
0810 CCA2 AD A2 1D              lda   |oldoutdev
0811 CCA5 48                    pha   
0812 CCA6 A2 0C 10 22           _SetOutputDevice 
0813 CCAD
0814 CCAD AD A0 1D              lda   |oldoutglob+2
0815 CCB0 48                    pha   
0816 CCB1 AD 9E 1D              lda   |oldoutglob
0817 CCB4 48                    pha   
0818 CCB5 A2 0C 0A 22           _SetOutGlobals 
0819 CCBC
0820 CCBC AD B8 1D              lda   |oldindev+4
0821 CCBF 48                    pha   
0822 CCC0 AD B6 1D              lda   |oldindev+2
0823 CCC3 48                    pha   
0824 CCC4 AD B4 1D              lda   |oldindev
0825 CCC7 48                    pha   
0826 CCC8 A2 0C 0F 22           _SetInputDevice 
0827 CCCF
0828 CCCF AD BC 1D              lda   |oldinglob+2
0829 CCD2 48                    pha   
0830 CCD3 AD BA 1D              lda   |oldinglob
0831 CCD6 48                    pha   
0832 CCD7 A2 0C 09 22           _setinglobals 
0833 CCDE
0834 CCDE E2 30                 shortmx 
0835 CCE0
0836 CCE0
0837 CCE0
0838 CCE0              ; Restore the old memory state.
0839 CCE0
0840 CCE0 AD 03 1D     rstmem   lda   |svstatereg
0841 CCE3 8D 68 C0              sta   |statereg                ;mega // kludge
0842 CCE6
0843 CCE6
0844 CCE6 C2 30                 longmx 
0845 CCE8
0846 CCE8 F4 00 00              PushWord #0 
0847 CCEB F4 20 00              PushWord #$20                  ;want 40 cols
0848 CCEE A2 03 0C 22           _ReadBParam 
0849 CCF5 68                    pla   
0850 CCF6 E2 30                 shortmx 
0851 CCF8 D0 0C                 bne   fast
0852 CCFA AF 1A 01 E1           lda   >irq_shadow+1
0853 CCFE 29 7F                 and   #%01111111
0854 CD00 8F 1A 01 E1           sta   >irq_shadow+1
0855 CD04 80 0A                 bra   checkvol
0856 CD06 AF 1A 01 E1  fast     lda   >irq_shadow+1
0857 CD0A 09 80                 ora   #%10000000
0858 CD0C 8F 1A 01 E1           sta   >irq_shadow+1
0859 CD10
0860 CD10 C2 30        checkvol longmx 
0861 CD12 F4 00 00              PushWord #0 
0862 CD15 F4 1E 00              PushWord #$1E 
0863 CD18 A2 03 0C 22           _ReadBParam 
0864 CD1F 68                    pla   
0865 CD20 E2 30                 shortmx 
0866 CD22 8F CA 00 E1           sta   >irq_volume
0867 CD26
0868 CD26 AF 00 1D E0           lda   >bregsave
0869 CD2A 48                    pha   
0870 CD2B AB                    plb   
0871 CD2C
0872 CD2C C2 30        exit     longmx 
0873 CD2E
0874 CD2E 5C DF FB FE           jml   oEndCall0
0875 CD32
0876 CD32                       ENDP 
0877 CD32
0878 CD32
0879 CD32
0880 CD32              **********************************************************************
0881 CD32              *
0882 CD32              * procedure InstallCDA (DAHandle : Handle);
0883 CD32              *
0884 CD32              * Takes a handle to the da to install on the stack
0885 CD32              *
0886 CD32              * Change History
0887 CD32              *
0888 CD32              * 25 Jul 88         Steven Glass
0889 CD32              *
0890 CD32              * Error code was loaded into a-reg instead of x-reg.  Fixed today.
0891 CD32              *
0892 CD32              * 
0893 CD32              * 10 Oct 88         Konstantin Othmer
0894 CD32              *
0895 CD32              * Since scrollable menu was added, number of CDAs is no longer limited
0896 CD32              * so this routine no longer returns an error code.
0897 CD32              *
0898 CD32              * Also temp1 and temp2 changed to MyTemp1 and MyTemp2 so zero page is no 
0899 CD32              * longer destroyed.
0900 CD32              *
0901 CD32              * 25 Oct 88         Steven Glass
0902 CD32              *
0903 CD32              * Moved code to unlock the handle into growtable.  Don't bother locking
0904 CD32              * and unlocking in this routine any more.
0905 CD32              *
0906 CD32              **********************************************************************
0907 CD32              InstCDA  PROC EXPORT
0908 CD32                       DefineStack 
0909 CD32              OrigD    word                           ;2
0910 CD32              MyTemp1  long                           ;4
0911 CD32              MyTemp2  long                           ;8
0912 CD32              ret1     block 3
0913 CD32              ret2     block 3
0914 CD32              DAHandle long 
0915 CD32
0916 CD32 48                    pha                            ; push 8 bytes of work space on stack
0917 CD33 48                    pha   
0918 CD34 48                    pha   
0919 CD35 48                    pha   
0920 CD36 0B                    phd                            ; save d-reg
0921 CD37
0922 CD37 3B                    tsc                            ; make stack into direct page
0923 CD38 5B                    tcd   
0924 CD39
0925 CD39 8B                    phb                            ; save dbr
0926 CD3A F4 E0 E0              pea   $E0E0
0927 CD3D AB                    plb   
0928 CD3E AB                    plb   
0929 CD3F AD 88 1D              lda   |roomleft                ; number of da's before we grow
0930 CD42 4A                    lsr   a
0931 CD43 4A                    lsr   a                        ; if less than 4 then grow
0932 CD44 D0 03                 bne   cont
0933 CD46
0934 CD46 20 82 CD              jsr   growtable
0935 CD49
0936 CD49 AD 84 1D     cont     lda   |cdatabhndl              ; dereference the handle
0937 CD4C 85 03                 sta   Mytemp1
0938 CD4E AD 86 1D              lda   |cdatabhndl+2
0939 CD51 85 05                 sta   Mytemp1+2
0940 CD53 20 76 CD              jsr   MyDeref
0941 CD56
0942 CD56 AD 7C 1D              lda   |numdas                  ; # of da's currently installed
0943 CD59 0A                    asl   a
0944 CD5A 0A                    asl   a
0945 CD5B A8                    tay   
0946 CD5C A5 11                 lda   DAHandle                 ; get lo part
0947 CD5E 97 07                 sta   [Mytemp2],y
0948 CD60 A5 13                 lda   DAHandle+2               ; get hi part
0949 CD62 C8                    iny   
0950 CD63 C8                    iny   
0951 CD64 97 07                 sta   [Mytemp2],y
0952 CD66 CE 88 1D              dec   |roomleft
0953 CD69 EE 7C 1D              inc   |numdas                  ; increment number of da's installed
0954 CD6C
0955 CD6C AB                    plb   
0956 CD6D 2B                    pld   
0957 CD6E
0958 CD6E 68                    pla   
0959 CD6F 68                    pla   
0960 CD70 68                    pla   
0961 CD71 68                    pla   
0962 CD72 5C 0D FC FE           jml   oEndCall4
0963 CD76
0964 CD76                       ENDP 
0965 CD76
0966 CD76              ****************************************************************
0967 CD76              *
0968 CD76              MyDeref  PROC EXPORT
0969 CD76              *
0970 CD76              * This routine is used by both InstallCDA and RemoveCDA to
0971 CD76              * dereference the handle in MyTemp1 and put the pointer in 
0972 CD76              * MyTemp2.
0973 CD76              *
0974 CD76              * The direct page layout is the same for InstallCDA, RemoveCDA
0975 CD76              * and this call.
0976 CD76              *
0977 CD76              *
0978 CD76              * Inputs:
0979 CD76              *	MyTemp1
0980 CD76              *
0981 CD76              * Outputs:
0982 CD76              *	MyTemp2
0983 CD76              *
0984 CD76              * External Refs:
0985 CD76              *	none
0986 CD76              *
0987 CD76              * Entry Points:
0988 CD76              *	none
0989 CD76              *
0990 CD76                       longa on                       ; mode
0991 CD76                       longi on
0992 CD76              *
0993 CD76              ****************************************************************
0994 CD76
0995 CD76
0996 CD76                       DefineStack                    ;(same as InstallCDA and RemoveCDA)
0997 CD76              OrigD    word 
0998 CD76              MyTemp1  long 
0999 CD76              MyTemp2  long 
1000 CD76              ret1     block 3
1001 CD76              ret2     block 3
1002 CD76              DAHandle long 
1003 CD76
1004 CD76 A0 02 00              ldy   #0002
1005 CD79 A7 03                 lda   [Mytemp1]
1006 CD7B 85 07                 sta   Mytemp2
1007 CD7D B7 03                 lda   [Mytemp1],y
1008 CD7F 85 09                 sta   Mytemp2+2
1009 CD81 60                    rts   
1010 CD82
1011 CD82                       ENDP 
1012 CD82
1013 CD82
1014 CD82              ****************************************************************
1015 CD82              *
1016 CD82              growtable PROC EXPORT
1017 CD82              *
1018 CD82              * This routine is called when the table of CDAs needs to
1019 CD82              * be grown.  It makes the handle $20 bytes bigger and 
1020 CD82              * increments RoomLeft by 8.
1021 CD82              *
1022 CD82              *
1023 CD82              * Inputs:
1024 CD82              *                   CDATabHndl
1025 CD82              *                   RoomLeft
1026 CD82              *
1027 CD82              * Outputs:
1028 CD82              *                   RoomLeft
1029 CD82              *
1030 CD82              * External Refs:
1031 CD82              *                   none
1032 CD82              *
1033 CD82              * Entry Points:
1034 CD82              *                   none
1035 CD82              *
1036 CD82                       longa on                       ; mode
1037 CD82                       longi on
1038 CD82              *
1039 CD82              *
1040 CD82              * Change History
1041 CD82              *
1042 CD82              * 25 Oct 88         Steven Glass
1043 CD82              *
1044 CD82              * No longer uses direct page.
1045 CD82              *
1046 CD82              ****************************************************************
1047 CD82
1048 CD82              ;-----------------------------------------------------------
1049 CD82              ;
1050 CD82              ; Make sure the table is not locked.
1051 CD82              ;
1052 CD82 AD 86 1D 48           pushlong |cdatabhndl 
1053 CD8A A2 02 22 22           _hunlock 
1054 CD91
1055 CD91
1056 CD91              ;-----------------------------------------------------------
1057 CD91              ;
1058 CD91              ; Get the table size.
1059 CD91              ;
1060 CD91 48                    pha   
1061 CD92 48                    pha   
1062 CD93 AD 86 1D 48           pushlong |cdatabhndl 
1063 CD9B A2 02 18 22           _gethandlesize 
1064 CDA2
1065 CDA2              ;-----------------------------------------------------------
1066 CDA2              ;
1067 CDA2              ; Add $20 and set the size.
1068 CDA2              ;
1069 CDA2 A3 01                 lda   1,s                      ; bump the size by $20
1070 CDA4 18                    clc   
1071 CDA5 69 20 00              adc   #$0020
1072 CDA8 83 01                 sta   1,s
1073 CDAA A3 03                 lda   3,s
1074 CDAC 69 00 00              adc   #$0000
1075 CDAF 83 03                 sta   3,s
1076 CDB1 AD 86 1D 48           pushlong |cdatabhndl 
1077 CDB9 A2 02 19 22           _sethandlesize 
1078 CDC0
1079 CDC0              ;-----------------------------------------------------------
1080 CDC0              ;
1081 CDC0              ; Bump room left.
1082 CDC0              ;
1083 CDC0 AD 88 1D              lda   |roomleft
1084 CDC3 18                    clc   
1085 CDC4 69 08 00              adc   #$08
1086 CDC7 8D 88 1D              sta   |roomleft
1087 CDCA
1088 CDCA 60                    rts   
1089 CDCB
1090 CDCB                       ENDP 
1091 CDCB
1092 CDCB              ****************************************************************
1093 CDCB              * RemoveCDA -- takes a handle to the da to remove on the stack
1094 CDCB              *
1095 CDCB              * Change History
1096 CDCB              *
1097 CDCB              * 05 Oct 88	Added by Konstantin Othmer
1098 CDCB              *
1099 CDCB
1100 CDCB              RemoveCDA PROC EXPORT
1101 CDCB
1102 CDCB                       DefineStack 
1103 CDCB
1104 CDCB              OrigD    word 
1105 CDCB              MyTemp1  long 
1106 CDCB              MyTemp2  long 
1107 CDCB              ret1     block 3 
1108 CDCB              ret2     block 3 
1109 CDCB              DAHandle long 
1110 CDCB
1111 CDCB 48                    pha                            ; push 8 bytes of work space on stack
1112 CDCC 48                    pha   
1113 CDCD 48                    pha   
1114 CDCE 48                    pha   
1115 CDCF 0B                    phd                            ; save d-reg
1116 CDD0 3B                    tsc                            ; make stack into direct page
1117 CDD1 5B                    tcd   
1118 CDD2
1119 CDD2 8B                    phb   
1120 CDD3 F4 E0 E0              pea   $E0E0
1121 CDD6 AB                    plb   
1122 CDD7 AB                    plb   
1123 CDD8
1124 CDD8 AD 86 1D 48           pushlong |cdatabhndl           ; push handle to da table
1125 CDE0 A2 02 20 22           _hlock                         ; lock the handle
1126 CDE7 AD 84 1D              lda   |cdatabhndl              ; dereference the handle
1127 CDEA 85 03                 sta   Mytemp1
1128 CDEC AD 86 1D              lda   |cdatabhndl+2
1129 CDEF 85 05                 sta   Mytemp1+2
1130 CDF1 20 76 CD              jsr   Myderef
1131 CDF4
1132 CDF4              ;try to find this handle in the list
1133 CDF4
1134 CDF4
1135 CDF4 A0 00 00              ldy   #0                       ;beginning of list
1136 CDF7              findCDA   
1137 CDF7 98                    tya   
1138 CDF8 4A                    lsr   a
1139 CDF9 4A                    lsr   a                        ;convert index to da number
1140 CDFA CD 7C 1D              cmp   |numdas
1141 CDFD D0 03                 bne   cont1                    ;if we've checked the whole list, branch
1142 CDFF 82 9E 00              brl   AllDone
1143 CE02
1144 CE02 A5 11        cont1    lda   DAHandle                 ; get lo part
1145 CE04 D7 07                 cmp   [Mytemp2],y
1146 CE06 D0 2C                 bne   notit
1147 CE08 C8                    iny   
1148 CE09 C8                    iny   
1149 CE0A A5 13                 lda   DAHandle+2               ; get hi part
1150 CE0C D7 07                 cmp   [Mytemp2],y
1151 CE0E D0 26                 bne   notit1
1152 CE10
1153 CE10              ;we found it.  Move all CDA's at [temp2],y+4 to [temp2],y
1154 CE10              ; currently y points to hi part of da to replace
1155 CE10
1156 CE10              move1     
1157 CE10
1158 CE10 C8                    iny   
1159 CE11 C8                    iny                            ;bump to lo part of next cda
1160 CE12 98                    tya   
1161 CE13 4A                    lsr   a
1162 CE14 4A                    lsr   a
1163 CE15 CD 7C 1D              cmp   |numdas                  ;check if there are more to move
1164 CE18 F0 20                 beq   RemoveDone
1165 CE1A B7 07                 lda   [Mytemp2],y              ;low part of CDA we want to move
1166 CE1C AA                    tax   
1167 CE1D C8                    iny   
1168 CE1E C8                    iny                            ;bump to high part
1169 CE1F B7 07                 lda   [Mytemp2],y              ;get high part
1170 CE21 88                    dey   
1171 CE22 88                    dey                            ;back to low part
1172 CE23 88                    dey   
1173 CE24 88                    dey                            ;high part of previous
1174 CE25 97 07                 sta   [Mytemp2],y              ;save high part
1175 CE27 88                    dey   
1176 CE28 88                    dey   
1177 CE29 8A                    txa   
1178 CE2A 97 07                 sta   [Mytemp2],y              ;save low part of previous
1179 CE2C C8                    iny   
1180 CE2D C8                    iny                            ;back to high part of previous
1181 CE2E C8                    iny   
1182 CE2F C8                    iny                            ;low part of next da to replace
1183 CE30 C8                    iny   
1184 CE31 C8                    iny                            ;high part of next da
1185 CE32 80 DC                 bra   move1
1186 CE34
1187 CE34              ;this isn't it.  Align pointer to next CDA entry.
1188 CE34
1189 CE34              notit                                   ;lo word didn't match: branches here
1190 CE34 C8                    iny   
1191 CE35 C8                    iny   
1192 CE36              notit1                                  ;high word didn't match: branch here
1193 CE36 C8                    iny   
1194 CE37 C8                    iny   
1195 CE38 80 BD                 bra   findCDA
1196 CE3A
1197 CE3A              RemoveDone  
1198 CE3A CE 7C 1D              dec   |numdas
1199 CE3D EE 88 1D              inc   |roomleft
1200 CE40
1201 CE40              ;unlock handle and then check to see if we can free up some space
1202 CE40
1203 CE40 AD 86 1D 48           pushlong |cdatabhndl 
1204 CE48 A2 02 22 22           _hunlock 
1205 CE4F A2 00 00              ldx   #0                       ;no error
1206 CE52 AD 88 1D              lda   |roomleft                ; number of da's before we grow
1207 CE55 C9 14 00              cmp   #20                      ;if there is room for 20 more, shrink by 12
1208 CE58 90 58                 bcc   ShrinkDone               ;branch if there is room for 20 or less
1209 CE5A
1210 CE5A              ;here we shrink the CDA handle size
1211 CE5A
1212 CE5A
1213 CE5A F4 00 00 F4           pushlong #$00 
1214 CE60 AD 86 1D 48           pushlong |cdatabhndl 
1215 CE68 A2 02 18 22           _gethandlesize 
1216 CE6F 68                    pla   
1217 CE70 38                    sec   
1218 CE71 E9 20 00              sbc   #$20
1219 CE74 85 03                 sta   Mytemp1
1220 CE76 68                    pla   
1221 CE77 E9 00 00              sbc   #$00
1222 CE7A 85 05                 sta   Mytemp1+2
1223 CE7C A5 05 48 A5           pushlong Mytemp1 
1224 CE82 AD 86 1D 48           pushlong |cdatabhndl 
1225 CE8A A2 02 19 22           _sethandlesize 
1226 CE91 AD 88 1D              lda   |roomleft
1227 CE94 38                    sec   
1228 CE95 E9 08 00              sbc   #$08
1229 CE98 8D 88 1D              sta   |roomleft
1230 CE9B A2 00 00              ldx   #0                       ;no error
1231 CE9E 80 12                 bra   ShrinkDone
1232 CEA0
1233 CEA0              AllDone   
1234 CEA0 AD 86 1D 48           pushlong |cdatabhndl 
1235 CEA8 A2 02 22 22           _hunlock 
1236 CEAF A2 10 05              ldx   #daNotFound              ;not found error: $0510
1237 CEB2
1238 CEB2              ShrinkDone                              ;handle has already been unlocked
1239 CEB2 AB                    plb   
1240 CEB3 2B                    pld   
1241 CEB4 68                    pla   
1242 CEB5 68                    pla   
1243 CEB6 68                    pla   
1244 CEB7 68                    pla   
1245 CEB8 5C 12 FC FE           jml   oErrOut4
1246 CEBC
1247 CEBC                       ENDP 
1248 CEBC
1249 CEBC
1250 CEBC
1251 CEBC
1252 CEBC              **********************************************************************
1253 CEBC              *
1254 CEBC              * setdastrptr
1255 CEBC              *
1256 CEBC              * This routine will	takes a pointer on the stack and will
1257 CEBC              * install it in dastrptr
1258 CEBC              *
1259 CEBC              * dastrptr points to the strings to be printed for the
1260 CEBC              * 2 builtin desk accessories -- Control	Panel and Quit, as
1261 CEBC              * well as the title	string for the desk	manager
1262 CEBC              *
1263 CEBC              * The pointer should point to a table containing pointers
1264 CEBC              * to c style strings (hi-bit on, zero terminated). The first
1265 CEBC              * entry in the table contains a pointer	to the title string, the second
1266 CEBC              * a pointer to the name of the control panel. The final string points to
1267 CEBC              * the name used for	the quit option
1268 CEBC              *
1269 CEBC              **********************************************************************
1270 CEBC              setdastrptr PROC EXPORT
1271 CEBC
1272 CEBC                       DefineStack 
1273 CEBC              Temp     LONG 
1274 CEBC              OrigB    BYTE 
1275 CEBC              OrigD    WORD 
1276 CEBC              Ret1     block 3
1277 CEBC              Ret2     block 3
1278 CEBC              strptr   long 
1279 CEBC              dahand   long 
1280 CEBC
1281 CEBC 0B                    phd                            ; save d-reg
1282 CEBD 8B                    phb                            ; save b-reg
1283 CEBE
1284 CEBE 48                    pha                            ; 4 bytes on stack
1285 CEBF 48                    pha   
1286 CEC0
1287 CEC0 3B                    tsc                            ; turn stack into d-page
1288 CEC1 5B                    tcd   
1289 CEC2
1290 CEC2
1291 CEC2 F4 E0 E0              pea   $E0E0                    ; set bank to $E0
1292 CEC5 AB                    plb   
1293 CEC6 AB                    plb   
1294 CEC7
1295 CEC7 A5 0E                 lda   strptr                   ; move strptr into final location
1296 CEC9 8D AC 1D              sta   |dastrptr
1297 CECC A5 10                 lda   strptr+2
1298 CECE 8D AE 1D              sta   |dastrptr+2
1299 CED1
1300 CED1 AD 86 1D              lda   |cdatabhndl+2            ; copy handle to temp
1301 CED4 85 03                 sta   temp+2
1302 CED6 AD 84 1D              lda   |cdatabhndl
1303 CED9 85 01                 sta   temp
1304 CEDB
1305 CEDB A0 04 00              ldy   #4                       ; lock the handle
1306 CEDE B7 01                 lda   [temp],y
1307 CEE0 09 00 80              ora   #$8000
1308 CEE3 97 01                 sta   [temp],y
1309 CEE5
1310 CEE5 A0 02 00              ldy   #2                       ; deref the handle
1311 CEE8 B7 01                 lda   [temp],y
1312 CEEA AA                    tax   
1313 CEEB A7 01                 lda   [temp]
1314 CEED 85 01                 sta   temp
1315 CEEF 86 03                 stx   temp+2
1316 CEF1
1317 CEF1 A0 02 00              ldy   #$0002                   ; copy the passed handle into the
1318 CEF4 A5 12                 lda   dahand                   ; first location in the derefed
1319 CEF6 87 01                 sta   [temp]                   ; table
1320 CEF8 A5 14                 lda   dahand+2
1321 CEFA 97 01                 sta   [temp],y
1322 CEFC
1323 CEFC AD 86 1D              lda   |cdatabhndl+2            ; unlock the handle
1324 CEFF 85 03                 sta   temp+2
1325 CF01 AD 84 1D              lda   |cdatabhndl
1326 CF04 85 01                 sta   temp
1327 CF06 A0 04 00              ldy   #0004
1328 CF09 B7 01                 lda   [temp],y
1329 CF0B 29 FF 7F              and   #$7fff
1330 CF0E 97 01                 sta   [temp],y
1331 CF10
1332 CF10 68                    pla                            ; clean off the stack (4 bytes)
1333 CF11 68                    pla   
1334 CF12 AB                    plb                            ; b-reg
1335 CF13 2B                    pld                            ; d-reg
1336 CF14
1337 CF14 5C 39 FC FE           jml   oEndCall8                ; call strip routine to strip inputs
1338 CF18
1339 CF18                       ENDP 
1340 CF18
1341 CF18
1342 CF18              ; returns the current value of dastrptr
1343 CF18
1344 CF18              getdastrptr PROC EXPORT
1345 CF18
1346 CF18              ret1     equ   1
1347 CF18              ret2     equ   ret1+3
1348 CF18              strptrlo equ   ret2+3
1349 CF18              strptrhi equ   strptrlo+2
1350 CF18
1351 CF18 AF AC 1D E0           lda   >dastrptr
1352 CF1C 83 07                 sta   strptrlo,s
1353 CF1E AF AE 1D E0           lda   >dastrptr+2
1354 CF22 83 09                 sta   strptrhi,s
1355 CF24 5C DF FB FE           jml   oEndCall0
1356 CF28
1357 CF28                       ENDP 
1358 CF28
1359 CF28
1360 CF28                       END   
